//************************************************************************************
//**  
//**  File name:     U:\SIN\PROJET\ProjetTerminal\Flowcode2.c
//**  Generated by:  Flowcode v4.5.18.74
//**  Date:          Thursday, April 10, 2014 14:40:39
//**  Licence:       10 User
//**  Registered to: LYCEE-ARISTIDE-BRIAND2
//**  
//**  
//**     POUR UN USAGE NON COMMERCIAL 
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_PIC

//Dfinir pour microcontrleur
#define P16F876A
#define MX_EE
#define MX_EE_TYPE2
#define MX_EE_SIZE 256
#define MX_SPI
#define MX_SPI_C
#define MX_SPI_SDI 4
#define MX_SPI_SDO 5
#define MX_SPI_SCK 3
#define MX_UART
#define MX_UART_C
#define MX_UART_TX 6
#define MX_UART_RX 7
#define MX_I2C
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 4
#define MX_I2C_SCL 3
#define MX_PWM
#define MX_PWM_CNT 2
#define MX_PWM_TRIS1 trisc
#define MX_PWM_1 2
#define MX_PWM_TRIS2 trisc
#define MX_PWM_2 1

//Fonctions
#define MX_CLK_SPEED 19660800
#ifdef _BOOSTC
#include <system.h>
#endif
#ifdef HI_TECH_C
#include <pic.h>
#endif

//Donnes de Configuration

//Fonctions internes
#include "C:\Program Files\Matrix Multimedia\Flowcode\FCD\internals.h"

//Dclarations de fonction Macro


//Dclarations de Variable
char FCV_BYTE;
char FCV_SENSOR;




//LCDDisplay(0): //Defines:

/**** Macro Substitutions ****
portb = D1 Port
trisb = D1 Data Direction
portb = D2 Port
trisb = D2 Data Direction
portb = D3 Port
trisb = D3 Data Direction
portb = D4 Port
trisb = D4 Data Direction
portb = RS Port
trisb = RS Data Direction
portb = E Port
trisb = E Data Direction
0 = Data 1_Pin
1 = Data 2 Pin
2 = Data 3 Pin
3 = Data 4 Pin
4 = RS Pin
5 = Enable Pin
LCD_328660 = Unique Component Reference Number
2 = Row Count
16 = Column Count
******************************/

	//component connections
	#define LCD_328660_PORT0    portb
	#define LCD_328660_TRIS0    trisb
	#define LCD_328660_PORT1    portb
	#define LCD_328660_TRIS1    trisb
	#define LCD_328660_PORT2    portb
	#define LCD_328660_TRIS2    trisb
	#define LCD_328660_PORT3    portb
	#define LCD_328660_TRIS3    trisb
	#define LCD_328660_PORT4    portb
	#define LCD_328660_TRIS4    trisb
	#define LCD_328660_PORT5    portb
	#define LCD_328660_TRIS5    trisb
	#define LCD_328660_BIT0    	0
	#define LCD_328660_BIT1    	1
	#define LCD_328660_BIT2    	2
	#define LCD_328660_BIT3    	3
	#define LCD_328660_RS      	4
	#define LCD_328660_E       	5
	#define LCD_328660_ROWCNT	2
	#define LCD_328660_COLCNT	16

	#ifdef _BOOSTC
	  #define LCD_328660_DELAY   delay_10us(10)
	#endif
	#ifdef _C2C_
	  #define LCD_328660_DELAY   delay_us(100)
	#endif
	#ifdef HI_TECH_C
	  #define LCD_328660_DELAY   __delay_us(120)
	#endif
	#ifndef LCD_328660_DELAY
	  #define LCD_328660_DELAY   delay_us(100)
	#endif

	#define ModIDLCD_328660LCD_328660 (((trisb << 5) + portb) << 9)




//LCDDisplay(0): //Dclarations de fonction Macro

void FCD_LCDDisplay0_RawSend(char in, char mask);
void FCD_LCDDisplay0_Start();
void FCD_LCDDisplay0_Clear();
void FCD_LCDDisplay0_PrintASCII(char Character);
void FCD_LCDDisplay0_Command(char in);
void FCD_LCDDisplay0_Cursor(char x, char y);
void FCD_LCDDisplay0_PrintNumber(short Number);
void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String);
void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions);
void FCD_LCDDisplay0_ClearLine(char Line);
void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7);


//One_Wire(0): //Defines:

/**** Macro Substitutions ****
0 = CRC Check Enable (0-Off / 1-On)
porta = One Wire Port Register
trisa = One Wire Data Direction Register
0 = One Wire Pin
%e = Clock Cycles For A 1us Delay
******************************/

	char FCD_One_Wire0_oo_get_next_id();
	void FCD_One_Wire0_tx_bit(char out);
	char FCD_One_Wire0_rx_bit();

#ifndef MX_MIAC
	#define CRC_CHECKING  	0
	#define OO_PORT  		porta
	#define OO_TRIS  		trisa
	#define OO_PIN  		0

	//Global Variables

	char oo_scratchpad[9];
	// Scratchpad contents
	// 0	Temperature LSB
	// 1	Temperature MSB
	// 2	Hi alarm temperature
	// 3	Lo alarm temperature
	// 4	Reserved, 0xFF
	// 5	Reserved, 0xFF
	// 6	Remainder register
	// 7	Nr of counts per degree
	// 8	CRC of pad contents


	// Commands for the OO
	//    1. ROM function commands
	#define        OO_READROM        	0x33
	#define        OO_MATCHROM       	0x55
	#define        OO_SKIPROM        	0xCC
	#define        OO_SEARCHROM      	0xF0
	#define        OO_ALARMSEARCH    	0xEC
	//    2. Memory Command Functions
	#define        OO_WRITEPAD       	0x4E
	#define        OO_READPAD        	0xBE
	#define        OO_COPYPAD        	0x48
	#define        OO_CONVERTT       	0x44
	#define        OO_RECALLE2			0xB8
	#define        OO_READSUPPLY		0xB4


	//I/O for the OO
	#define Float_OO {set_bit(OO_TRIS, OO_PIN);}
	#define Clear_OO {clear_bit(OO_TRIS, OO_PIN);	clear_bit(OO_PORT, OO_PIN);}

	// CRC working variable
	char crc = 0;

	//CRC for the OO
	#if CRC_CHECKING == 1

		// CRC lookup table
		#ifdef _BOOSTC
			rom char* crc_rom = {0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
				157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
				35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
				190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
				70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
				219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
				101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
				248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
				140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
				17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
				175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
				50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
				202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
				87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
				233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
				116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};
		#endif

		#ifdef HI_TECH_C
			const char crc_rom[] = {0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
				157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
				35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
				190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
				70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
				219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
				101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
				248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
				140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
				17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
				175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
				50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
				202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
				87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
				233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
				116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};
		#endif

	#endif


	// Internal variables
	char        id[8];
	signed char conflict;
	char        new_conflict;


	//Device ID Variables
	char num_devices = 0;
	char DevID[64] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
						0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#endif




//One_Wire(0): //Dclarations de fonction Macro

void FCD_One_Wire0_oo_crc_shuffle_byte(char input);
void FCD_One_Wire0_oo_crc_init();
char FCD_One_Wire0_rx_bit();
void FCD_One_Wire0_tx_bit(char out);
char FCD_One_Wire0_oo_get_next_id();
char FCD_One_Wire0_oo_busreset();
char FCD_One_Wire0_oo_get_pad_byte(char index);
void FCD_One_Wire0_oo_tx_byte(char data);
char FCD_One_Wire0_oo_rx_byte();
char FCD_One_Wire0_oo_scanbus();
char FCD_One_Wire0_oo_get_devicecount();
char FCD_One_Wire0_oo_read_device(char count);
char FCD_One_Wire0_oo_get_IDByte(char device, char octet);
char FCD_One_Wire0_DS1820_start_conversion();
char FCD_One_Wire0_DS1820_read_scratchpad();
short FCD_One_Wire0_DS1820_get_temp();



//LCDDisplay(0): //Implmentations Macro


void FCD_LCDDisplay0_RawSend(char in, char mask)
{
	
	#ifndef MX_MIAC_SYSTEM
		unsigned char pt;

		clear_bit(LCD_328660_PORT0, LCD_328660_BIT0);
		clear_bit(LCD_328660_PORT1, LCD_328660_BIT1);
		clear_bit(LCD_328660_PORT2, LCD_328660_BIT2);
		clear_bit(LCD_328660_PORT3, LCD_328660_BIT3);
		clear_bit(LCD_328660_PORT4, LCD_328660_RS);
		clear_bit(LCD_328660_PORT5, LCD_328660_E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    set_bit(LCD_328660_PORT0, LCD_328660_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_328660_PORT1, LCD_328660_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_328660_PORT2, LCD_328660_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_328660_PORT3, LCD_328660_BIT3);
		if (mask)
		    set_bit(LCD_328660_PORT4, LCD_328660_RS);
		LCD_328660_DELAY;
		set_bit (LCD_328660_PORT5, LCD_328660_E);
		LCD_328660_DELAY;
		clear_bit (LCD_328660_PORT5, LCD_328660_E);
		pt = (in & 0x0f);
		LCD_328660_DELAY;
		clear_bit(LCD_328660_PORT0, LCD_328660_BIT0);
		clear_bit(LCD_328660_PORT1, LCD_328660_BIT1);
		clear_bit(LCD_328660_PORT2, LCD_328660_BIT2);
		clear_bit(LCD_328660_PORT3, LCD_328660_BIT3);
		clear_bit(LCD_328660_PORT4, LCD_328660_RS);
		clear_bit(LCD_328660_PORT5, LCD_328660_E);
		if (pt & 0x01)
		    set_bit(LCD_328660_PORT0, LCD_328660_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_328660_PORT1, LCD_328660_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_328660_PORT2, LCD_328660_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_328660_PORT3, LCD_328660_BIT3);
		if (mask)
		    set_bit(LCD_328660_PORT4, LCD_328660_RS);
		LCD_328660_DELAY;
		set_bit (LCD_328660_PORT5, LCD_328660_E);
		LCD_328660_DELAY;
		clear_bit (LCD_328660_PORT5, LCD_328660_E);
		LCD_328660_DELAY;

	#endif

}

void FCD_LCDDisplay0_Start()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = 0;
		MIAC_CAN_TX[1] = 1;
		MIAC_CAN_TX[2] = 2;
		MIAC_CAN_TX[3] = 3;
		MIAC_CAN_TX[4] = 4;
		MIAC_CAN_TX[5] = 5;

		MIAC_Module_WR(ModIDLCD_328660, 608, 6,1,1);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 608, 20);

		MIAC_CAN_TX[0] = 2;
		MIAC_CAN_TX[1] = 16;
		MIAC_Module_WR(ModIDLCD_328660, 608, 2,0,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 608, 255);

	  #endif
	#else

		clear_bit(LCD_328660_TRIS0, LCD_328660_BIT0);
		clear_bit(LCD_328660_TRIS1, LCD_328660_BIT1);
		clear_bit(LCD_328660_TRIS2, LCD_328660_BIT2);
		clear_bit(LCD_328660_TRIS3, LCD_328660_BIT3);
		clear_bit(LCD_328660_TRIS4, LCD_328660_RS);
		clear_bit(LCD_328660_TRIS5, LCD_328660_E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);
	#endif

}

void FCD_LCDDisplay0_Clear()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_Module_WR(ModIDLCD_328660, 609, 0,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 609, 200);
	  #endif
	#else
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);
	#endif

}

void FCD_LCDDisplay0_PrintASCII(char Character)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)



		MIAC_CAN_TX[0] = Character;

		MIAC_Module_WR(ModIDLCD_328660, 610, 1,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 610, 20);
	  #endif
	#else
		FCD_LCDDisplay0_RawSend(Character, 0x10);
	#endif

}

void FCD_LCDDisplay0_Command(char in)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = in;

		MIAC_Module_WR(ModIDLCD_328660, 611, 1,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 611, 200);
	  #endif
	#else
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);
	#endif

}

void FCD_LCDDisplay0_Cursor(char x, char y)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = x;
		MIAC_CAN_TX[1] = y;

		MIAC_Module_WR(ModIDLCD_328660, 612, 2,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 612, 20);
	  #endif

	#else

	  #if (LCD_328660_ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_328660_ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_328660_ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_328660_COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_328660_COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);
	#endif

}

void FCD_LCDDisplay0_PrintNumber(short Number)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[1] = Number;
		MIAC_CAN_TX[0] = Number >> 8;

		MIAC_Module_WR(ModIDLCD_328660, 613, 4,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 613, 200);
	  #endif

	#else

		short tmp_int;
		char tmp_byte;

		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);
	#endif

}

void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String)
{
	
		char idx = 0;

	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		char msg_count, ch;
		char cmd_start = 1;
		char more_data = 1;

		// Split string into 6-byte packets
		do
		{
			msg_count = 0;
			do
			{
				ch = String[idx];
				if (ch)
				{
					MIAC_CAN_TX[msg_count] = ch;
					idx = idx + 1;
					msg_count = msg_count + 1;
				}
			}
			while (ch && (msg_count < 6) && (idx < MSZ_String));			// check for 2 x End Of String conditions and packet full

			if (idx == MSZ_String)											// end of string
			{
				more_data = 0;
			}else{
				if (String[idx] == 0) more_data = 0;						// next ch = null
			}

			MIAC_Module_WR(ModIDLCD_328660, 614, msg_count,cmd_start,more_data);		// TX data
			MIAC_Module_GetAck(ModIDLCD_328660 + 32, 614, 200);

			cmd_start = 0;
		}
		while (more_data);
	  #endif
	#else
		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx] == 0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}
	#endif

}

void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = Direction;
		MIAC_CAN_TX[1] = Num_Positions;

		MIAC_Module_WR(ModIDLCD_328660, 615, 2,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 615, 20);
	  #endif
	#else

		char cmd = 0;
		char count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}
	#endif

}

void FCD_LCDDisplay0_ClearLine(char Line)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = Line;

		MIAC_Module_WR(ModIDLCD_328660, 616, 1,1,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 616, 200);
	  #endif
	#else
		char count;
		char rowcount;

		//Define number of columns per line
		#if (LCD_328660_ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_328660_ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_328660_ROWCNT == 4)
			#if (LCD_328660_COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_328660_COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);
	#endif

}

void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7)
{
	   //set CGRAM address

	#ifdef MX_MIAC_SYSTEM
	  #if (portb != MX_MIAC_MM_MIAC_BASE)

		MIAC_CAN_TX[0] = nIdx;
		MIAC_CAN_TX[1] = d0;
		MIAC_CAN_TX[2] = d1;
		MIAC_CAN_TX[3] = d2;
		MIAC_CAN_TX[4] = d3;
		MIAC_CAN_TX[5] = d4;

		MIAC_Module_WR(ModIDLCD_328660, 617, 6,1,1);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 617, 20);

		MIAC_CAN_TX[0] = d5;
		MIAC_CAN_TX[1] = d6;
		MIAC_CAN_TX[2] = d7;

		MIAC_Module_WR(ModIDLCD_328660, 617, 3,0,0);
		MIAC_Module_GetAck(ModIDLCD_328660 + 32, 617, 200);

	  #endif
	#else

	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);
	#endif

}



//One_Wire(0): //Implmentations Macro


void FCD_One_Wire0_oo_crc_shuffle_byte(char input)
{
	
	#ifndef MX_MIAC
		#if CRC_CHECKING == 1
			crc = crc_rom[crc ^ input];
		#endif
	#endif
}

void FCD_One_Wire0_oo_crc_init()
{
	
	#ifndef MX_MIAC
		#if CRC_CHECKING == 1
			crc = 0;
		#endif
	#endif
}

char FCD_One_Wire0_rx_bit()
{
	
	#ifndef MX_MIAC
		char oo_bit, count;
		Clear_OO;							//Clear Output Pin
		delay_us(1);						//Delay 1us
		Float_OO;							//Float Output Pin
		delay_us(10);						//Delay 10us
		oo_bit = test_bit(OO_PORT, OO_PIN);	//Test Input
		delay_us(50);						//Delay 50us
		return oo_bit;
	#endif
}

void FCD_One_Wire0_tx_bit(char out)
{
	
	#ifndef MX_MIAC
		char count;
		Clear_OO;							//Clear Output Pin
		delay_us(1);						//Delay 1us
		if (out & 0x01)
			Float_OO;						//Float Output Pin
		delay_us(60);						//Delay 60us
		Float_OO;							//Float Output Pin
		delay_us(10);						//Delay 10us
	#endif
}

char FCD_One_Wire0_oo_get_next_id()
{
	
	#ifndef MX_MIAC
		char val0 = 0;
		char val1 = 0;
		char counter    = 0;
		char bit_index  = 0;
		char byte_index = 0;
		//char current_conflict = -1;

		//added JCMB 10/01/09
		char lz_selected = 0;
		char go_on = 0;
		char bit_test;

		new_conflict = 0;

		if ( FCD_One_Wire0_oo_busreset() )	// Reset the bus
		{
			return 1; // -> error
		}
		// Issue the search ROM command
		FCD_One_Wire0_oo_tx_byte(OO_SEARCHROM);

		// Start the search for the sensor
		for (byte_index = 0; byte_index < 8; byte_index++)
		{
			char data_in_byte = 0;
			for (bit_index = 0; bit_index < 8; bit_index++)
			{
				// Read 2 consecutive bits from the One Wire bus
				val0 = FCD_One_Wire0_rx_bit();						//Test Input
				val1 = FCD_One_Wire0_rx_bit();						//Test Input

				// Evaluate the result
				if ((val0 == 0) && (val1 == 0))
				{
					//current_conflict = counter;
					// if conflict occurs earlier than the previous conflict, then use the previous value
					if (counter < conflict)
					{
						// use previous value
						bit_test = id[byte_index] >> bit_index;		//added JCMB 10/01/09
						if (bit_test & 0x01)
						{
							val0 = 1;
						}
						else
						{
							val0 = 0;
							lz_selected = counter;				//added JCMB 10/01/09
							go_on = 1;							//added JCMB 10/01/09
						}
					}
					else if (counter == conflict)
					{
						// use 1
						val0 = 1;
					}
					else
					{
						// use zero on new conflicts
						val0 = 0;
						conflict = counter;
						new_conflict = 1;
					}
				}
				else if (val0 && val1) // 1 et 1 impossible
				{
					return 2;
				}
				// Store the bit in the ID array
				data_in_byte = data_in_byte >> 1;
				if (val0)
				{
					data_in_byte |= 0x80;
				}

				FCD_One_Wire0_tx_bit(val0);

				counter++;
			}
			id[byte_index] = data_in_byte;
		}

	        //added JCMB 10/01/09
		if ((new_conflict == 0) && go_on)
		{
			new_conflict = 1;
			conflict = lz_selected ;
		}

		// Verify ID CRC
		#if CRC_CHECKING == 1
			FCD_One_Wire0_oo_crc_init();
		#endif

		for (byte_index = 0; byte_index < 8; byte_index++)
		{
			#if CRC_CHECKING == 1
					FCD_One_Wire0_oo_crc_shuffle_byte(id[byte_index]);
			#endif
		}
		// Bail on CRC errors
	  #if CRC_CHECKING == 1
		if (crc) return crc;
	  #endif
		return 0;
	#endif
}

char FCD_One_Wire0_oo_busreset()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (porta != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_CAN_TX[0] = 0;
		MIAC_Module_WR(ModID, 545, 1,1,0);
		MIAC_Module_GetAck(ModID + 32, 545, 20);
	  #endif
	#else
		Float_OO; 						// Release bus
		Clear_OO;						// Send the reset pulse
		delay_us(200);					// Wait for 600 s, this is the reset pulse
		delay_us(200);
		delay_us(200);
		Float_OO; 						// Release bus
		delay_us(60);					// Wait 60 us (release) let device drive the bus
		if (test_bit(OO_PORT, OO_PIN) == 1)	// Now sample, if there is a sensor on the bus, the line should be low
			return 1; 					// <<-error
		delay_us(140);					// Wait another 540 us to complete the reset sequence
		delay_us(200);
		delay_us(200);
		return 0;
	#endif
}

char FCD_One_Wire0_oo_get_pad_byte(char index)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_CAN_TX[0] = index;
		MIAC_Module_WR(ModID, 546, 1,1,0);
		MIAC_Module_GetAck(ModID + 32, 546, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		return oo_scratchpad[index];
	#endif
}

void FCD_One_Wire0_oo_tx_byte(char data)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_CAN_TX[0] = 0;
		MIAC_CAN_TX[1] = data;
		MIAC_Module_WR(ModID, 547, 2,1,0);
		MIAC_Module_GetAck(ModID + 32, 547, 20);
	  #endif
	#else
		char counter = 0;
		while (counter < 8)
		{
			FCD_One_Wire0_tx_bit(data);
			data = data >> 1;				//Rotate to next bit of data
			counter++;						//Increment Counter
		}
	#endif
}

char FCD_One_Wire0_oo_rx_byte()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 548, 0,1,0);
		MIAC_Module_GetAck(ModID + 32, 548, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char counter = 0;
		char data    = 0;
		char oo_bit  = 0;
		while (counter < 8)
		{
			oo_bit = FCD_One_Wire0_rx_bit();
			data = data >> 1;					//Shift incoming data to next bit
			if (oo_bit > 0)
			{
				data = data | 0x80;				//Append incoming bit to data byte
			}
			counter++;							//Increment Counter
		}
		#ifdef OO_CRC_CHECKING
			FCD_One_Wire0_oo_crc_shuffle_byte(data);			//Check CRC
		#endif
		return data;
	#endif
}

char FCD_One_Wire0_oo_scanbus()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 549, 0,1,0);
		MIAC_Module_GetAck(ModID + 32, 549, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char retval = 0;
		char device_count = 0;
		char loper;
		conflict = -1;
		new_conflict = 1;
		// Reset the bus, wake up devices.
		retval = FCD_One_Wire0_oo_busreset();
		if (retval == 1)
		{
			return 255; // -> error
		}
		// new_conflict gets updated in the FCD_One_Wire0_oo_get_next_id() function.
		while (new_conflict)
		{
			retval = FCD_One_Wire0_oo_get_next_id();
			// Bail in case of errors
			if (retval) return retval;
			// Add the device id to EEPROM
			for (loper=0; loper < 8; loper++)
			{
				DevID[loper+(device_count<<3)] = id[loper];
			}
			device_count++;
		}
		// Write number of devices to the EEPROM
		num_devices = device_count;
		return 0;
	#endif
}

char FCD_One_Wire0_oo_get_devicecount()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 550, 0,1,0);
		MIAC_Module_GetAck(ModID + 32, 550, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		return num_devices;
	#endif
}

char FCD_One_Wire0_oo_read_device(char count)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_CAN_TX[1] = count;
		MIAC_Module_WR(ModID, 551, 1,1,0);
		MIAC_Module_GetAck(ModID + 32, 551, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char loper = 0;
		char counter = 0;
		char temp;
		short value;
		FCD_One_Wire0_oo_busreset();
		FCD_One_Wire0_oo_tx_byte(OO_MATCHROM);
		for (loper=0; loper < 8; loper++)
		{
			id[loper] = DevID[loper+(count<<3)];
			FCD_One_Wire0_oo_tx_byte(id[loper]);
		}
		FCD_One_Wire0_oo_tx_byte(OO_READPAD);
		#if CRC_CHECKING == 1
			FCD_One_Wire0_oo_crc_init();			//Reset the CRC register, CRC is updated in the FCD_One_Wire0_oo_rx_byte() function.
		#endif
		while (counter < 9)
		{
			temp = FCD_One_Wire0_oo_rx_byte();
			oo_scratchpad[counter] = temp;
			counter++;
		}
		#if CRC_CHECKING == 1
			return crc;				//Verify the CRC
		#endif
		return 0;
	#endif
}

char FCD_One_Wire0_oo_get_IDByte(char device, char octet)
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_CAN_TX[0] = device;
		MIAC_CAN_TX[1] = octet;
		MIAC_Module_WR(ModID, 552, 2,1,0);
		MIAC_Module_GetAck(ModID + 32, 552, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char retval = 255;
		if ((device >= num_devices) | (octet > 7))
		{
			return retval ; //error
		}
	        retval = DevID[octet+(device<<3)];
		return retval ;
	#endif
}

char FCD_One_Wire0_DS1820_start_conversion()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 553, 0,1,0);
		MIAC_Module_GetAck(ModID + 32, 553, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char in = 0;
		char counter = 0;
		FCD_One_Wire0_oo_busreset();
		FCD_One_Wire0_oo_tx_byte(OO_SKIPROM);		// Command all temp sensors on the bus to start a conversion
		FCD_One_Wire0_oo_tx_byte(OO_CONVERTT);	// Convert temperature
		while (in == 0)
		{
			in = FCD_One_Wire0_oo_rx_byte();
			delay_ms(4);
			counter++;
			if (counter == 0xFF)		// Security: if the conversion is not completed
				return 1;				// after > 1 sec -> break.
		}
		return 0;
	#endif
}

char FCD_One_Wire0_DS1820_read_scratchpad()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 554, 0,1,0);
		MIAC_Module_GetAck(ModID + 32, 554, 20);

		return(MIAC_CAN_RX[0]);
	  #endif
	#else
		char temp;
		char counter = 0;
		if ( FCD_One_Wire0_oo_busreset() )
			return (1);
		FCD_One_Wire0_oo_tx_byte(OO_SKIPROM);		//Command all temp sensors on the bus to start a conversion
		FCD_One_Wire0_oo_tx_byte(OO_READPAD);		//Convert temperature
		#if CRC_CHECKING == 1
			FCD_One_Wire0_oo_crc_init();			//Reset the CRC register, CRC is updated in the FCD_One_Wire0_oo_rx_byte() function.
		#endif
		while (counter < 9)
		{
			temp = FCD_One_Wire0_oo_rx_byte();
			oo_scratchpad[counter] = temp;
			counter++;
		}
		#if CRC_CHECKING == 1
			return crc;				//Verify the CRC
		#endif
		return 0;
	#endif
}

short FCD_One_Wire0_DS1820_get_temp()
{
	
	#ifdef MX_MIAC_SYSTEM
	  #if (0 != MX_MIAC_MM_MIAC_BASE)

		unsigned int ModID = ((trisa << 5) + porta) << 9;

		MIAC_Module_WR(ModID, 555, 2,1,0);
		MIAC_Module_GetAck(ModID + 32, 555, 20);

		return((MIAC_CAN_RX[0] << 8) | MIAC_CAN_RX[1]);
	  #endif
	#else
		short retval;
		retval = oo_scratchpad[1];
		retval = retval << 8;
		retval = retval | oo_scratchpad[0];
		return retval;
	#endif
}

//Implmentations Macro

void main()
{
	
	//Initialisation
	adcon1 = 0x07;

	
	#ifdef MX_MIAC_SYSTEM
	  #if (porta != MX_MIAC_MM_MIAC_BASE)

		#define MOD_ID	((trisa << 5) + porta) << 9

		MIAC_CAN_TX[0] = 0;
		MIAC_CAN_TX[1] = 0;
		MIAC_Module_WR(MOD_ID, 544, 1,1,0);
		MIAC_Module_GetAck(MOD_ID + 32, 544, 20);

		#undef MOD_ID

	  #endif
	#endif


	//Code d'initialisation d'Interruption
	option_reg = 0xC0;


	//Appel de la Routine Composant
	//Appel de la Routine Composant: LCDDisplay(0)::Init
	FCD_LCDDisplay0_Start();


	//Appel de la Routine Composant
	//Appel de la Routine Composant: LCDDisplay(0)::Effacer
	FCD_LCDDisplay0_Clear();


	//Appel de la Routine Composant
	//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_busreset
	FCV_BYTE = FCD_One_Wire0_oo_busreset();


	//Pause
	//Pause: 1 ms
	delay_ms(1);


	//Appel de la Routine Composant
	//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_get_pad_byte(BYTE)
	FCV_BYTE = FCD_One_Wire0_oo_get_pad_byte(FCV_BYTE);


	//Dcision
	//Dcision: BYTE>=1?
	if (FCV_BYTE>=1)
	{
		//Appel de la Routine Composant
		//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_scanbus
		FCV_BYTE = FCD_One_Wire0_oo_scanbus();


		//Appel de la Routine Composant
		//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_get_devicecount
		FCV_BYTE = FCD_One_Wire0_oo_get_devicecount();


		//Dcision
		//Dcision: BYTE>=1?
		if (FCV_BYTE>=1)
		{
			//Appel de la Routine Composant
			//Appel de la Routine Composant: LCDDisplay(0)::crit_Caractre("Temprature")
			FCD_LCDDisplay0_PrintASCII('T');
			FCD_LCDDisplay0_PrintASCII('e');
			FCD_LCDDisplay0_PrintASCII('m');
			FCD_LCDDisplay0_PrintASCII('p');
			FCD_LCDDisplay0_PrintASCII('');
			FCD_LCDDisplay0_PrintASCII('r');
			FCD_LCDDisplay0_PrintASCII('a');
			FCD_LCDDisplay0_PrintASCII('t');
			FCD_LCDDisplay0_PrintASCII('u');
			FCD_LCDDisplay0_PrintASCII('r');
			FCD_LCDDisplay0_PrintASCII('e');


			//Appel de la Routine Composant
			//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_read_device(BYTE)
			FCV_BYTE = FCD_One_Wire0_oo_read_device(FCV_BYTE);


			//Appel de la Routine Composant
			//Appel de la Routine Composant: BYTE=One_Wire(0)::oo_get_IDByte(Sensor, BYTE)
			FCV_BYTE = FCD_One_Wire0_oo_get_IDByte(FCV_SENSOR, FCV_BYTE);


			//Appel de la Routine Composant
			//Appel de la Routine Composant: LCDDisplay(0)::Curseur(12, 0)
			FCD_LCDDisplay0_Cursor(12, 0);


			//Appel de la Routine Composant
			//Appel de la Routine Composant: LCDDisplay(0)::crit_Nombre(BYTE)
			FCD_LCDDisplay0_PrintNumber(FCV_BYTE);


		}


	}


	mainendloop: goto mainendloop;
}

void MX_INTERRUPT_MACRO(void)
{
}



